/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.tileentity;

import dev.toma.gunsrpg.common.init.ModBlockEntities;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.init.ModRecipeTypes;
import dev.toma.gunsrpg.common.tileentity.VanillaInventoryTileEntity;
import dev.toma.gunsrpg.resource.cooking.CookingRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CookerTileEntity
extends VanillaInventoryTileEntity
implements IRecipeHolder,
ITickableTileEntity,
ISidedInventory {
    public static final byte SLOT_INPUT = 0;
    public static final byte SLOT_FUEL = 1;
    public static final byte SLOT_OUTPUT = 2;
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipes = new Object2IntOpenHashMap();
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;

    public CookerTileEntity() {
        this((TileEntityType<? extends CookerTileEntity>)((TileEntityType)ModBlockEntities.COOKER.get()));
    }

    protected CookerTileEntity(TileEntityType<? extends CookerTileEntity> type) {
        super((TileEntityType<? extends VanillaInventoryTileEntity>)type);
    }

    public int getLitTime() {
        return this.litTime;
    }

    public int getLitDuration() {
        return this.litDuration;
    }

    public int getCookingProgress() {
        return this.cookingProgress;
    }

    public int getCookingTotalTime() {
        return this.cookingTotalTime;
    }

    @Override
    public IItemHandlerModifiable createInventory() {
        return new ItemStackHandler(3);
    }

    public void func_73660_a() {
        boolean wasLit = this.isLit();
        boolean gotLit = false;
        if (this.isLit()) {
            --this.litTime;
        }
        ItemStack fuelStack = this.itemHandler.getStackInSlot(1);
        if (this.isLit() || !fuelStack.func_190926_b() && !this.itemHandler.getStackInSlot(1).func_190926_b()) {
            gotLit = this.runCookProcess(fuelStack);
        } else if (!this.isLit() && this.cookingProgress > 0) {
            this.cookingProgress = MathHelper.func_76125_a((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (wasLit != this.isLit()) {
                gotLit = true;
                this.updateBlockLitState(this.isLit());
            }
            if (gotLit) {
                this.func_70296_d();
            }
        }
    }

    public void awardExperienceFromRecipes(PlayerEntity player) {
        List<IRecipe<?>> recipes = this.getRecipesForAwardsWithExp(player.field_70170_p, player.func_213303_ch());
        player.func_195065_a(recipes);
        this.usedRecipes.clear();
    }

    public List<IRecipe<?>> getRecipesForAwardsWithExp(World level, Vector3d position) {
        ArrayList list = new ArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipes.object2IntEntrySet()) {
            level.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                if (recipe instanceof CookingRecipe) {
                    list.add((IRecipe<?>)recipe);
                    this.createExperience(level, position, entry.getIntValue(), (CookingRecipe)recipe);
                }
            });
        }
        return list;
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            this.usedRecipes.addTo((Object)recipe.func_199560_c(), 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public int[] func_180463_a(Direction direction) {
        int[] nArray;
        if (direction == Direction.DOWN) {
            return new int[]{0, 1};
        }
        if (direction == Direction.UP) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    public boolean func_180462_a(int slot, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && slot == 1) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        return stack.func_77973_b() == ModItems.COOKING_OIL;
    }

    @Override
    public void func_70299_a(int id, ItemStack stack) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(id);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack);
        this.itemHandler.setStackInSlot(id, stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (id == 0 && !flag) {
            this.cookingTotalTime = this.getItemCookTimeSlow();
            this.cookingProgress = 0;
            this.func_70296_d();
        }
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.litTime = nbt.func_74762_e("litTime");
        this.litDuration = this.getBurnDuration(this.itemHandler.getStackInSlot(1));
        this.cookingProgress = nbt.func_74762_e("cookingProgress");
        this.cookingTotalTime = nbt.func_74762_e("cookingTotalTime");
        CompoundNBT used = nbt.func_74775_l("usedRecipes");
        for (String key : used.func_150296_c()) {
            this.usedRecipes.put((Object)new ResourceLocation(key), used.func_74762_e(key));
        }
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74768_a("litTime", this.litTime);
        nbt.func_74768_a("cookingProgress", this.cookingProgress);
        nbt.func_74768_a("cookingTotalTime", this.cookingTotalTime);
        CompoundNBT used = new CompoundNBT();
        this.usedRecipes.forEach((k, v) -> used.func_74768_a(k.toString(), v.intValue()));
        nbt.func_218657_a("usedRecipes", (INBT)used);
    }

    public <R extends IRecipe<?>> boolean canCook(R recipe) {
        if (!this.itemHandler.getStackInSlot(0).func_190926_b() && recipe != null) {
            ItemStack stack = recipe.func_77572_b((IInventory)this);
            int resultAmount = stack.func_190916_E();
            if (stack.func_190926_b()) {
                return false;
            }
            ItemStack out = this.itemHandler.getStackInSlot(2);
            if (out.func_190926_b()) {
                return true;
            }
            if (!out.func_77969_a(stack)) {
                return false;
            }
            if (out.func_190916_E() + resultAmount <= this.func_70297_j_() && out.func_190916_E() + resultAmount <= out.func_77976_d()) {
                return true;
            }
            return out.func_190916_E() + resultAmount <= stack.func_77976_d();
        }
        return false;
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    public int getBurnDuration(ItemStack fuel) {
        return fuel.func_77973_b() == ModItems.COOKING_OIL ? 1600 : 0;
    }

    public int getItemCookTimeSlow() {
        CookingRecipe recipe = this.findSuitableRecipe();
        return this.getItemCookTime(recipe);
    }

    public int getItemCookTime(CookingRecipe recipe) {
        return recipe != null ? recipe.getCookTime() : 200;
    }

    public void cook(CookingRecipe recipe) {
        if (recipe != null && this.canCook(recipe)) {
            ItemStack input = this.itemHandler.getStackInSlot(0);
            ItemStack result = recipe.assemble(this);
            ItemStack output = this.itemHandler.getStackInSlot(2);
            if (output.func_190926_b()) {
                this.itemHandler.setStackInSlot(2, result);
            } else if (output.func_77973_b() == result.func_77973_b()) {
                int resultAmount = result.func_190916_E();
                output.func_190917_f(resultAmount);
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            input.func_190918_g(1);
        }
    }

    public void updateBlockLitState(boolean state) {
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(state)), 3);
    }

    private CookingRecipe findSuitableRecipe() {
        RecipeManager manager = this.field_145850_b.func_199532_z();
        Optional cookingRecipeOptional = manager.func_215371_a(ModRecipeTypes.COOKING_RECIPE_TYPE, (IInventory)this, this.field_145850_b);
        return cookingRecipeOptional.orElse(null);
    }

    private void createExperience(World level, Vector3d position, int count, CookingRecipe recipe) {
        float value = recipe.getExperience();
        int i = MathHelper.func_76141_d((float)((float)count * value));
        float f = MathHelper.func_226164_h_((float)((float)count * value));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int expVal = ExperienceOrbEntity.func_70527_a((int)i);
            i -= expVal;
            level.func_217376_c((Entity)new ExperienceOrbEntity(level, position.field_72450_a, position.field_72448_b, position.field_72449_c, expVal));
        }
    }

    private boolean runCookProcess(ItemStack fuelStack) {
        boolean changed = false;
        CookingRecipe recipe = this.findSuitableRecipe();
        if (!this.isLit() && this.canCook(recipe)) {
            this.litDuration = this.litTime = this.getBurnDuration(fuelStack);
            if (this.isLit()) {
                changed = true;
                if (fuelStack.hasContainerItem()) {
                    this.itemHandler.setStackInSlot(1, fuelStack.getContainerItem());
                } else if (!fuelStack.func_190926_b()) {
                    fuelStack.func_190918_g(1);
                    if (fuelStack.func_190926_b()) {
                        this.itemHandler.setStackInSlot(1, fuelStack.getContainerItem());
                    }
                }
            }
        }
        if (this.isLit() && this.canCook(recipe)) {
            ++this.cookingProgress;
            if (this.cookingProgress == this.cookingTotalTime) {
                this.cookingProgress = 0;
                this.cookingTotalTime = this.getItemCookTime(recipe);
                this.cook(recipe);
                changed = true;
            }
        } else {
            this.cookingProgress = 0;
        }
        return changed;
    }
}

